
    /**
     * Set up buttons and links to popup pages.  Steps to do:
     * <button class="popup" data-url="" ..../>
     * 
     * 1. Your element's CSS clas should include 'popup'
     * 2. You should have attribute data-url:           This is the URL to open of popup.
     * 3. You should have attribute data-varkey:        This is the varKey to pass to the page opened up.
     * 4. You should have attribute data-popupAction:   This is a jQuery selector of a button to invoke upon successful completion.  If absent, the form is submitted without a button and will probably reload.
     * 
     */
	$(document).ready (function () {
		//when a link with class popup is clicked
		$(".popup").click(function(){
			
			//set element attributes to variables
			var     url = $(this).attr("data-url");
    	    var     varkey = $(this).attr("data-varkey"); 
    	    var     popupAction = $(this).attr("data-popupAction");
    	    var     aForm = $(this).parents('form');
    	    var     procID = aForm.find("input[name = 'proc.ID']").val();
    	    var     procStage = aForm.find("input[name = 'proc.stage']").val ();
    	    
    	    //this element exists on the header
    	    var     theDialog = $("#iFrameDialog");

    	    //write the iframe code to the above element
    	    theDialog.html ("<iframe class='popup' width='100%' height='100%' src='" + (url + "?varKey=" + varkey + "&proc.ID=" + procID + "&proc.stage=" + procStage) + "'>");
    	    
            if ($(this).data('dialogOptions')) {
                theDialog.dialog ($(this).data('dialogOptions'));
            } else {
                theDialog.dialog ({ height: 800, width: 1300, modal: true });
            }

    	    //once the page in the popup has executed a server side action, the below code will get executed
    	    //these are call back handlers
    	    manager.onSuccess = function (result) {
    		    
    	    	//set the new stage in the page 
	            var  procStage   = result.stage;
	            aForm.find("input[name = 'proc.stage']").val (procStage);
				
	            //close the dialog
	            theDialog.dialog ("close");
	            
	            //submit the page
                if (popupAction)
                {
                    log ("Popup Complete: will click button", popupAction, $(popupAction));
                    $(popupAction).click();
                }
                else
                {
                    log ("Popup Complete: will submit form", $(aForm));
                    $(aForm).submit();
                }
	            
	        };
	    	
	        //if the popupu window page, form processer caused an error.
	        manager.onFailure = function (data) {
	            theDialog.dialog ("close");
	        };
			
	  });
		
		
});


//when a link with class popup is clicked
		
	function openPopupWindow(url){
			
			//set element attributes to variables
    	    var     varkey = $(this).attr("data-varkey");    
    	    var     aForm = $(this).parents('form');
    	    var     procID = aForm.find("input[name = 'proc.ID']").val();
    	    var     procStage = aForm.find("input[name = 'proc.stage']").val ();
    	    //this element exists on the header
    	    var     theDialog = $("#iFrameDialog");
    	    alert(procID);

    	    //write the iframe code to the above element
    	    theDialog.html ("<iframe class='popup' width='100%' height='100%' src='" + (url + "?varKey=" + varkey + "&proc.ID=" + procID + "&proc.stage=" + procStage) + "'>");
    	    
            if ($(this).data('dialogOptions')) {
                theDialog.dialog ($(this).data('dialogOptions'));
            } else {
                theDialog.dialog ({ height: 800, width: 1300, modal: true });
            }

    	    //once the page in the popup has executed a server side action, the below code will get executed
    	    //these are call back handlers
    	    manager.onSuccess = function (result) {
    		    
    	    	//set the new stage in the page 
	            var  procStage   = result.stage;
	            aForm.find("input[name = 'proc.stage']").val (procStage);
				
	            //close the dialog
	            theDialog.dialog ("close");
	            
	            //submit the page
	            //$("#submitJob").click();
	            $(aForm).submit();
	            
	        };
	    	
	        //if the popup window page, form processor caused an error.
	        manager.onFailure = function (data) {
	            theDialog.dialog ("close");
	        };
			
	  }
